
=pod
=encoding utf8
=head1 config.pm
 Configuration file for POL, the named-entity detection and categorisation
 See documentation in: 
 http://www.tecling.com/pol
=cut

$home = "/home/";
$server = "nacosta/web"; 
$folder =  "/pol/source"; # no es necesario, basta con definir el home
$home .= $server.$folder; 
&abort("\nNo home! ($home)") if (! -d $home);
#$traindata = $home."/posnecwiki/"; # aquí es donde tenemos los datos de entrenamiento
 #$traindata = "/media/roger/roger/posnecwiki/";
 $traindata = $home."/posnecwiki/";
&abort("\nNo traindata! ($traindata)") if (! -d $traindata);
my @files = <$traindata/*>;
$train = @files; # este es el total de ficheros
$model = "/models_3izq_f3/"; # una vez entrenado, hay que especificar aquí de modelo
$excl = "stoplist.txt"; # es un listado de exclusión ordenada por frecuencia. Formato: palabra tab frecuencia
$umbral = 5000; # de manera totalmente arbitraria seleccionamos este rango de frecuencia del stoplist
$stop = ',|\.|de|el|los|la|las|\(|\)|y|ser|un|una|que|o|\-|"'; # un ministoplist aparte usado en el training
$gramema = 'del?|la|para'; # frecuentes componentes invernos de un nombre propio que estarán en la lista de exclusión
$adverbio = "mente"; # ayuda a detectar adverbios acabados en mente, debe adaptarse a otras lenguas
$min = 1; # frecuencia mínima que tiene que tener un elemento para ser tenido en cuenta
$window = 3; # la ventana de contexto (posiciones antes del nombre)
$dir = "l"; # puede ser l (izq) o r (der)
%postag = ( "V" => "Verbo",	"A" => "Adjetivo","N" => "Nombre",
	"C" => "Conjunción", "D" => "Determinante", "P" => "Pronombre",	"R" => "Advervio","S" => "Preposición");
	# Dejado de lado: "F" => "Puntuación", #"Z" => "Número", # Y las fechas: [??:??/6/??:??.??:??]
$model = $home.$model;
mkdir $model if (! -d $model);
$nombres = $home.$nombres;
&abort("\nNo está el modelo de entrenamiento ($model)") if (! -d $model);
%tags = ( # expansión de nombres, # "G" => "PLACE", "SP" => "HUMAN","O" => "ORGANIZATION","V" => "OTHER",
		"G" => "LUGAR",	"SP" => "PERSONA","O" => "ORGANIZACIÓN","V" => "VARIOS"	);
sub abort { # si se quiere personalizar el mensaje de despedida.
	print "\n".$_[0]; # necesario para la demo web
	die;
}
1;
