

=pod

	Script para convertir storable en tsv

=cut

use strict;
use Storable;
use Encode;
$|++;

my $model = "models_3izq_f3/"; # carpeta donde está el modelo guardado por poltrain.pl
my %tipo;
opendir(DIR, $model); # leemos el directorio donde está el modelo
my @FILES = readdir(DIR);
closedir(DIR);
foreach my $file (@FILES) { # cargamos el modelo en memoria
	next if ($file =~ /^\.+$/) || $file !~ /\.str$/;
	# next if ($params && !$params{$file}); 
	warn "\nLoading $file...";
	%{$tipo{$file}} = %{retrieve($model.$file)};
}

my $dir = "indexpol/"; # directorio donde se guardará el modelo en el nuevo formato
mkdir $dir if ( ! -d $dir );

foreach my $classifier ( keys %tipo ) {
	print "\n$classifier";
	my $buffer;
	my ($content, $ofile);
	foreach my $np (sort keys %{$tipo{$classifier}} ) {
		next if ($np =~ /'[^ \/\t\.,;\(\)&%\$=!"\'#\*]+'/);
		my $primerastres = substr ($np, 0, 3);
		$primerastres = encode('utf8', $primerastres);
		$ofile = "$classifier\_$buffer.txt";
		if (!$buffer) {
			$buffer = $primerastres;
			$ofile = "$classifier\_$primerastres.txt";
		} elsif ($buffer ne $primerastres) {
			# escribo fichero
			#print "\nCambio de $buffer a $primerastres!";
			open OUT, ">", $dir.$ofile or warn "\n I can't write file $ofile:".$!;
			print OUT $content;
			close OUT;
			# reinicializo $buffer
			$content = '';
			$buffer = $primerastres;
		}
		$content .= "\n$np";
		foreach my $cat ( sort { $tipo{$classifier}{$np}{$b} <=> $tipo{$classifier}{$np}{$a} } keys %{$tipo{$classifier}{$np}} ) {
				$content .= "\n\t$cat\t$tipo{$classifier}{$np}{$cat}";
		}
	}
}
