use strict;
use Encode;
$|++;

my $input = $ARGV[0];
my $home = "./";
my $model = $home."indexpol/"; # una vez entrenado, hay que especificar aquí de modelo
my %tags = ( # expansión de nombres, # "G" => "PLACE", "SP" => "HUMAN","O" => "ORGANIZATION","V" => "OTHER",
		"G" => "LUGAR",	"SP" => "PERSONA","O" => "ORGANIZACIÓN","V" => "VARIOS"	);
my $undef = "INDEFINIDO";
my $excl = "stoplist.txt";
my $umbral = 5000;
my $gramema = 'del?|la|para';
my $adverbio = "mente";
my $window = 3;

sub readfile {
	open(FILE, '<', $_[0]) or warn "No puedo abrir el fichero $_[0]";
	my @in = <FILE>;
	close FILE;
	return @in;
};

sub leerCategorias {
		my ($file, $input) = @_;

		my @context = &readfile($file);
		my $context = join '', @context;
		my @input = split /_/, $input;

		if ($context =~ /$input/){
			my @cntxt = split(/\n$input/, $context);
			if ($cntxt[1] =~ /([^\n]+)/){
				return $1;
			}
		}elsif ($context =~ /$input[0]/ && $context !~ /$input/){
			my @cntxt = split(/\n$input[0]/, $context);
			if ($cntxt[1] =~ /([^\n]+)/){
				return $1;
			}
		}else{
			warn "No existe $input en $_[0]!\n";
		}
}

my @input = &readfile($input); # leemos el archivo de input
my @excl = &readfile($excl); # la lista de exclusión

$input = join '', @input;
$input =~ s/([ ,\.:;\?¿!\]\[\(\)…\r\n"]+)/ $1 /g;
@input = split / +/, $input; #mínimo preproceso
my %excl;

foreach my $l (@excl) { # cargamos en memoria el stoplist
	chomp $l;
	my ($w, $f) = split /\t/, $l;
	$excl{$w}++ if ($f > $umbral);
}

my ($segmento, # se abre o cierra para permitir la segmentación de los canidatos
@ctxt, # los tres tokens anteriores al target
%ctxt,
%candidatos); 
foreach my $tok (@input) {
	my $i = substr ($tok, 0, 1);
	my $lc = lc $i;
	my $lctok = lc $tok;
	if ($i ne $lc) { # it's a candidate
		if (!$segmento && $lctok !~ /$adverbio$/ ) { 
			$segmento = $tok;
		} elsif ($segmento) {
			$segmento .= "_".$tok;
		}
	} elsif ($segmento && $tok =~ /^($gramema)$/) { 
		$segmento .= "_".$tok;
	} elsif ($segmento) {
		$candidatos{$segmento}++;
		foreach my $w (@ctxt) {
			$ctxt{$segmento}{$w}++;
		}	
		undef $segmento;
	}
	push (@ctxt, $tok);
	while (scalar(@ctxt) > $window) { # mantiene una memoria de los tres tokens anteriores
		shift @ctxt;
	}
}

foreach my $input (sort keys %candidatos){

	my $lcand = lc $input;	
	next if ($input =~ /[ _]($gramema)$/); 
	next if ($input =~ /^[XVI]+$/); # siglos
	if ($excl{$input} || $excl{$lcand} || $input =~ / ($gramema)$/ || $lcand =~ /$adverbio$/
			|| $input =~ /^(Al|Adónde)$/ # alro raro! No sé por qué no los detecta antes.
		 ) {
		next;
	}

	my $let = substr ($input, 0, 3);
	$let = encode("utf8", $let);

	my $cmpnts = &leerCategorias($model."cmpnts.str_$let.txt", $input);
	my $cntxt = &leerCategorias($model."cntxt.str_$let.txt", $input);
	
	#print "$input\n$cmpnts\n\n$cntxt\n";
	
	my @cmpnts = split /\t/, $cmpnts;
	my @cntxt = split /\t/, $cntxt;

	while ($input =~ /_/){
		$input =~ s/_/ /;
	}	
		
	if (!$cmpnts[2] && !$cntxt[2]){
		next;
	}elsif (!$cmpnts[2] && $cntxt[2]){
		print "$input\t$tags{$cntxt[1]}\n";
	}elsif ($cmpnts[2] && !$cntxt[2]){
		print "$input\t$tags{$cmpnts[1]}\n";
	}elsif ($cmpnts[2] > $cntxt[2]){
		print "$input\t$tags{$cmpnts[1]}\n";
	}elsif ($cmpnts[2] < $cntxt[2]){
		print "$input\t$tags{$cntxt[1]}\n";
	}elsif ($cmpnts[2] == $cntxt[2]){
		print "$input\t$tags{$cmpnts[1]}\n";
	}
}
