
=pod

=encoding utf8
=head1 poltrain.pl

:POL Detección y clasificación de nombres propios en las categorías de Persona, Organización y Lugar
http://www.tecling.com/pol

=head1 Licencia open source

    poltrain.pl - Perl script for the training of POL, the named-entity detection and categorisation system
    Copyright (C) 2016  Rogelio Nazar

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

=head1 Referencia: 
Nazar, R.; Arriagada, P. (2017). "POL: un nuevo método para la detección y clasificación de nombres propios". Procesamiento del lenguaje natural, nro. 58. 

=head1 Descripción: 
Este script se invoca solamente para el entrenamiento de clasificador de entidades. 
El input es el training data. Genera varios modelos, entre ellos el vocabulario.

=head1 Bugs y advertencias:

Tal como está ahora, el script depende del etiquetario usado por Freeling.
Para usarlo con otro etiquetario, naturalmente habrá que editar el código.

=cut
use strict;
use Storable;
$|++;
our ($home, $folder, $model, $traindata, $train, $stop, $min, $window, $dir, $server, %postag); # definidos en config.pm
require "config.pm";
my %tipo;
foreach my $i (1 .. $train ) { # es el nro de docs en que está dividido el corpus. 
	my $file = $traindata."/POSNECWikiPart$i.txt"; # los ficheros siguen este patrón de orden. Se deberá modificar de ser necesario.
	warn "Processing file $file...";
	warn "\nNot found! " and next if (! -e $file);
	&filexfile($file);
	warn "Ok!";
}
sub filexfile {
   my $file = $_[0];
   open(FILE, "<", $file) or die "No puedo abrir el fichero $file";
   my @file = <FILE>;
   close FILE;
   foreach my $ln (0 .. $#file) {# warn "\nReading $file\t$ln" if ($ln =~ /00000$/);
	if ( $file[$ln] =~ /NP00([^ 0]+)0/ )  { # encuentra un nombre propio
		my $tipo = $1;
		$file[$ln] =~ /^([^ ]+) / or next;
		my $enty = $1;	# $tipo{'cmpnts'}{$enty}{$tipo}++; 
		my @tmp = split /_/, $enty;
		push (@tmp, $enty) if (scalar(@tmp) > 1);
		foreach my $c (@tmp){
			$tipo{'cmpnts'}{$c}{$tipo}++; 
		}
		# recorro el contexto de n tok de izq a der
		my ($start, $finish);
		$dir = $ARGV[1] if (!$dir && $ARGV[1]);
		if ($dir eq "der") {
			$start = $ln + scalar(@tmp); 
			$finish = $start + $window;
		} else {
			$start = ($ln-$window); 
			$finish = $ln;
		} 
		foreach my $i ($start .. $finish) {
			next if ($i == $ln);
			$file[$i] =~ /^([^ ]+) ([^ ]+) (.)/ or next;
			my $tok = $1; #Su su DP3CS0 1 #capital capital NCFS000 #es ser VSIP3S0 
			my $lema = $2; #la el DA0FS0 #ciudad ciudad NCFS000 #de de SPS00 #Ottawa ottawa NP00G00
			next if ($tok =~ /^($stop)$/ || $lema =~ /^($stop)$/ );
			my $pos = $3; 
			$tipo{'cntxt'}{$tok}{$tipo}++; # el tipo asociado al contexto
			if ($postag{$pos}) {
				$tipo{$postag{$pos}}{$tok}{$tipo}++;
			}
		}
	}
   }
}
print "\nFinished reading data. Now saving...";
foreach my $classifier ( keys %tipo ) {
	print "\nSaving $classifier..."; # el modelo puede presentarse en txt o en binario
	foreach my $np ( keys %{$tipo{$classifier}}) { # sort en caso de print
		my $survive;
		foreach my $type ( keys %{$tipo{$classifier}{$np}}) { # sort en caso de print
			if ($tipo{$classifier}{$np}{$type} >= $min) {
				$survive++; # print "\n\t$type\t$tipo{$np}{$type}";
			} else {
				delete $tipo{$classifier}{$np}{$type};
			}
		}
		if (!$survive) {
			delete $tipo{$classifier}{$np};
		}
	}
	store \%{$tipo{$classifier}}, $model.$classifier.".str";
	delete $tipo{$classifier};
}

